<?php

/*omicron STYLISH CATEGORIES */



if (!defined('_PS_VERSION_'))

	exit;

	

class omicronCategories extends Module

{

	private $_html = '';

	private $_postErrors = array();



	public function __construct()

	{

		$this->name = 'omicronCategories';

		$this->tab = 'front_office_features';

		$this->version = '1.0';

		$this->author = 'DigitalOmicron';

		$this->need_instance = 0;



		parent::__construct();



		$this->displayName = $this->l('Stylish Category Tab on home page');

		$this->description = $this->l('Add a block which enables Stylish Category Tab on home page.');

		$context = Context::getContext();

		$this->id_shop = $context->shop->id;

	}



	/**

	 * @see ModuleCore::install()

	 */

	public function install()

	{

		$id_lang = (int)Context::getContext()->language->id;

		$languages = $this->context->controller->getLanguages();

		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');

		

		$sql_TabSettings = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."omicrontabsettings` (

							  `id_tab` TINYINT( 1 ) NOT NULL AUTO_INCREMENT,

							  `name` VARCHAR( 128 ) NOT NULL,

							  `alias_name` VARCHAR( 128 ) NOT NULL,

							  `type` VARCHAR( 128 ) NOT NULL,

							  `position` TINYINT( 1 ) NOT NULL,

							  `cat_id` TINYINT( 1 ) NOT NULL,

							  `id_shop` TINYINT( 1 ) NOT NULL,

							  `status` enum('0','1') NOT NULL DEFAULT '1',

							  PRIMARY KEY (`id_tab`)

							) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC";

		Db::getInstance()->Execute($sql_TabSettings);

		

		$sql_TabLang = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."omicrontabsettingslang` (

							  `tab_id` tinyint(3) NOT NULL,

							  `id_lang` INT(11) UNSIGNED NOT NULL,

							  `name`  VARCHAR( 128 ) NOT NULL,

							  `alias_name`  VARCHAR( 128 ) NOT NULL

							) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC";	Db::getInstance()->Execute($sql_TabLang);

							

		$sql_ProdSettings = "CREATE TABLE IF NOT EXISTS `"._DB_PREFIX_."omicrontab_products` (

							  `tab_id` TINYINT( 1 ) NOT NULL,

							  `products`  VARCHAR( 128 ) NOT NULL

							) ENGINE=MyISAM  DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC";	Db::getInstance()->Execute($sql_ProdSettings);

							

		$id_shop = $this->context->shop->id;

		

		$sqlIns1 = "INSERT INTO "._DB_PREFIX_."omicrontabsettings(name,alias_name,type,position,id_shop)

						    VALUES('Featured products','Featured products','special',1,".$this->id_shop.")"; Db::getInstance()->Execute($sqlIns1);

		

		$tabId = Db::getInstance()->Insert_ID();

		

		foreach ($languages as $language){

			 

			//$this->l(trim($valArr[0]))

			$sql_Ins = "INSERT INTO "._DB_PREFIX_."omicrontabsettingslang(tab_id,id_lang,name,alias_name)

				VALUES('".$tabId."','".$language["id_lang"]."','".$this->l("Featured products")."','".$this->l("Featured products")."')";	

			Db::getInstance()->Execute($sql_Ins);

		}

		

		

		$sqlIns2 = "INSERT INTO "._DB_PREFIX_."omicrontabsettings(name,alias_name,type,position,id_shop)

						    VALUES('New Arrivals','New Arrivals','special',2,".$this->id_shop.")";	Db::getInstance()->Execute($sqlIns2);

		$tabId = Db::getInstance()->Insert_ID();

		

		foreach ($languages as $language){

			//$this->l(trim($valArr[0]))

			$sql_Ins = "INSERT INTO "._DB_PREFIX_."omicrontabsettingslang(tab_id,id_lang,name,alias_name)

				VALUES('".$tabId."','".$language["id_lang"]."','".$this->l("New Arrivals")."','".$this->l("New Arrivals")."')";	

			Db::getInstance()->Execute($sql_Ins);

		}

		

		if (!parent::install() 

				|| !$this->registerHook('displayHome')

				|| !$this->registerHook('hometabCategory') 

				|| !$this->registerHook('header')

				)

			return false;

		return true;

	}



	public function uninstall()

	{

		$sqlDropSettings = "DROP TABLE `"._DB_PREFIX_."omicrontabsettings`";

		$sqlDropSettingsLang = "DROP TABLE `"._DB_PREFIX_."omicrontabsettingslang`";

		$sqlDropproducts = "DROP TABLE `"._DB_PREFIX_."omicrontab_products`";

		if (!parent::uninstall() 

			|| !(Db::getInstance()->Execute($sqlDropSettings))

			|| !(Db::getInstance()->Execute($sqlDropproducts))

			|| !(Db::getInstance()->Execute($sqlDropSettingsLang))

		)

			return false;

		return true;

	}



	public function getContent()

	{

		$output = '<h2>'.$this->displayName.'</h2>';

		$id_shop = $this->context->shop->id;

		extract($_POST);

		if(isset($tabid)){

			

			if (Tools::isSubmit('submit_'.$tabid)){

				$status = 'status_'.$tabid; $status = $$status;

				$sqlSelType = "SELECT type FROM "._DB_PREFIX_."omicrontabsettings WHERE id_tab=".$tabid;

				$type=  Db::getInstance()->getValue($sqlSelType);

				$sqlUpd = "UPDATE "._DB_PREFIX_."omicrontabsettings SET status='".$status."' WHERE id_tab=".$tabid;

				Db::getInstance()->Execute($sqlUpd);

				

				$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');

				$languages = Language::getLanguages(false);

				foreach ($languages as $language){

					$aliasname = 'aliasname_'.$tabid.'_'.$language["id_lang"]; 

					$aliasname = $$aliasname;	 

					$sql_Upd = "UPDATE "._DB_PREFIX_."omicrontabsettingslang SET alias_name='".$aliasname."' WHERE tab_id=".$tabid." AND id_lang=".$language["id_lang"];	

					Db::getInstance()->Execute($sql_Upd);

				}

				if($type=="custom"){

					$sqlSelTab = "SELECT tab_id FROM "._DB_PREFIX_."omicrontab_products WHERE tab_id=".$tabid;

					$tab=  Db::getInstance()->getValue($sqlSelTab);					

					if($tab){

						if($selProduct)

						{	$sql = "UPDATE "._DB_PREFIX_."omicrontab_products SET products='".$selProduct."' WHERE tab_id=".$tabid; Db::getInstance()->Execute($sql); }

					}else{

						$sql = "INSERT INTO "._DB_PREFIX_."omicrontab_products(tab_id,products)VALUES(".$tabid.",'".$selProduct."')";

						Db::getInstance()->Execute($sql);

					}

					

				}

				$output .= '<div class="conf confirm updated">'.$this->l('Settings Updated').'</div>';

			}	

		}

		if (Tools::isSubmit('submit_add'))

		{	extract($_POST);		

			

			

			$tabArr = explode(",",$selectedTab);

			$sqlSel = "SELECT COUNT(*) FROM "._DB_PREFIX_."omicrontabsettings WHERE id_shop=".$id_shop;

			$countTab = Db::getInstance()->getValue($sqlSel);

			if(!$countTab){ $countTab=1;}else{$countTab+=1;}

			foreach($tabArr as $tab){

				

				$valArr = explode("_",$tab);

				$flagExists =0;

				if($valArr[1] == "category" || $valArr[1] == "special"){

					$sqlSel = "SELECT COUNT(*) FROM "._DB_PREFIX_."omicrontabsettings WHERE name='".$valArr[0]."' AND id_shop=".$id_shop;

					$flagExists = Db::getInstance()->getValue($sqlSel);

				}

				if(isset($valArr[2])){

					$sql_Ins = "INSERT INTO "._DB_PREFIX_."omicrontabsettings(name,alias_name,type,cat_id,position,id_shop)

						    VALUES('".trim($valArr[0])."','".trim($valArr[0])."','".$valArr[1]."',".$valArr[2].",".$countTab.",".$id_shop.")";	

				}

				else{

					$sql_Ins = "INSERT INTO "._DB_PREFIX_."omicrontabsettings(name,alias_name,type,position,id_shop)

						    VALUES('".trim($valArr[0])."','".trim($valArr[0])."','".$valArr[1]."',".$countTab.",".$id_shop.")";	

				}

				if(($valArr[1] == "category" || $valArr[1] == "special") && ($flagExists==0))

				{

					Db::getInstance()->Execute($sql_Ins);

				}

				elseif($valArr[1] == "custom")

				{

					Db::getInstance()->Execute($sql_Ins);

				}

				if(!$flagExists){

					$tabId = Db::getInstance()->Insert_ID();

					$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');

					$languages = Language::getLanguages(false);

					foreach ($languages as $language){

						$sql_Ins = "INSERT INTO "._DB_PREFIX_."omicrontabsettingslang(tab_id,id_lang,name,alias_name)

						    VALUES('".$tabId."','".$language["id_lang"]."','".$this->l(trim($valArr[0]))."','".$this->l(trim($valArr[0]))."')";	

						Db::getInstance()->Execute($sql_Ins);

					}

					 

				}

				$countTab++;

			}

				if($flagExists){

					$output .= '<div class="conf error">'.$this->l('This section is already added').'</div>';

				}else{

					$output .= '<div class="conf confirm updated">'.$this->l('New Section Added Sucessfully').'</div>';

				}

			

			} 

		

			$output .= '<div class="conf confirm deleted" style="display:none;">'.$this->l('Deleted Sucessfully').'</div>';

			$output .= '<div class="conf confirm addedalready" style="display:none;">'.$this->l('This section is already added').'</div>';

			$output .= '<div class="conf confirm posChange" style="display:none;">'.$this->l('Position Changed').'</div>';

			

		

		return $output.$this->displayForm();

	}

	

	public function getTree($resultParents, $resultIds, $maxDepth, $id_category = null, $currentDepth = 0)

	{

		if (is_null($id_category))

			$id_category = $this->context->shop->getCategory();



		$children = array();

		if (isset($resultParents[$id_category]) && count($resultParents[$id_category]) && ($maxDepth == 0 || $currentDepth < $maxDepth))

			foreach ($resultParents[$id_category] as $subcat)

				$children[] = $this->getTree($resultParents, $resultIds, $maxDepth, $subcat['id_category'], $currentDepth + 1);

		if (!isset($resultIds[$id_category]))

			return false;

		$return = array('id' => $id_category, 'link' => $this->context->link->getCategoryLink($id_category, $resultIds[$id_category]['link_rewrite']),

					 'name' => $resultIds[$id_category]['name'], 'desc'=> $resultIds[$id_category]['description'],

					 'children' => $children);

		return $return;

	}

	

	public function displayForm()

	{	global $smarty,$cookie; $html='';

		$id_shop = $this->context->shop->id;

		$id_customer = (int)$cookie->id_customer;

		$groups = $id_customer ? implode(', ', Customer::getGroupsStatic($id_customer)) : Configuration::get('PS_UNIDENTIFIED_GROUP');

		$id_product = (int)Tools::getValue('id_product', 0);

		$id_category = (int)Tools::getValue('id_category', 0);

		$tabSelect = Tools::getValue('tabSelect');

		if(!$tabSelect) $tabSelect=1;

		$id_lang = (int)($cookie->id_lang);

		$maxdepth = Configuration::get('BLOCK_CATEG_MAX_DEPTH');

		

		$resCat = Db::getInstance()->ExecuteS('

				SELECT c.id_parent, c.id_category, cl.name, cl.description, cl.link_rewrite

				FROM `'._DB_PREFIX_.'category` c

				INNER JOIN `'._DB_PREFIX_.'category_lang` cl ON (c.`id_category` = cl.`id_category` AND cl.`id_lang` = '.$id_lang.Shop::addSqlRestrictionOnLang('cl').')

				INNER JOIN `'._DB_PREFIX_.'category_shop` cs ON (cs.`id_category` = c.`id_category` AND cs.`id_shop` = '.(int)$this->context->shop->id.')

				WHERE (c.`active` = 1 OR c.`id_category` = '.(int)Configuration::get('PS_HOME_CATEGORY').')

				AND c.`id_category` != '.(int)Configuration::get('PS_ROOT_CATEGORY').'

				'.((int)$maxdepth != 0 ? ' AND `level_depth` <= '.(int)$maxdepth : '').'

				AND c.id_category IN (SELECT id_category FROM `'._DB_PREFIX_.'category_group` WHERE `id_group` IN ('.pSQL($groups).'))

				ORDER BY `level_depth` ASC, '.(Configuration::get('BLOCK_CATEG_SORT') ? 'cl.`name`' : 'cs.`position`').' '.(Configuration::get('BLOCK_CATEG_SORT_WAY') ? 'DESC' : 'ASC'));	

		

		foreach ($resCat as &$row)

		{

			$resultParents[$row['id_parent']][] = &$row;

			$resultIds[$row['id_category']] = &$row;

		}



		$blockCategTree = $this->getTree($resultParents, $resultIds, Configuration::get('BLOCK_CATEG_MAX_DEPTH'));

		

		$id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');

		$languages = Language::getLanguages(false);

		

		

		$html.= '<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.$this->name.'/styles/style.css" />

		<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.$this->name.'/styles/bootstrap.css" />

		<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.$this->name.'/styles/icons.css" />

		<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.$this->name.'/styles/backend.css" />

		<link type="text/css" rel="stylesheet" href="'._MODULE_DIR_.$this->name.'/styles/jquery-ui.css" />

		<script src="'._MODULE_DIR_.$this->name.'/javascript/jqueryUI.js"></script>

	

		<script>

			$(function() {

				setTimeout(function() {

					$(".confirm, .error").hide("slow");

				}, 2000);

			});

			$(function() {

			$( "#sortable" ).sortable({

				//placeholder: "ui-state-highlight",

				update: function(e, ui) {        

					ui.item.attr("data-currindex", ui.item.index());

					var catPos = new Array();

		

					$( "#sortable li" ).each(function(){

						var id = $(this).attr("id");

						var posIndex = parseInt($(this).index());

						$("#position_"+id).val(posIndex);

						catPos[posIndex] = id;				

					});					

					var path = $("#path_1").val()+"ajaxPage.php?callFor=changePosition&catPos="+catPos;

					

					$.ajax({

						url:path,

						success:function(data){										

							$(".confirm").hide("slow");

							$(".posChange").show("slow").delay(2000).fadeOut("slow");

					} });

				}

			});

			$( "#sortable" ).disableSelection();

			});

		</script>

		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">

		<div class="admin-wrapper">

			<input type="hidden" name="tabSelect" id="tabSelect" value="'.$tabSelect.'" />

			<fieldset>

				';

				$sqlSelProd = 'SELECT p.`id_product`, pl.`name`

						FROM `'._DB_PREFIX_.'product` p

						'.Shop::addSqlAssociation('product', 'p').'

						LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` '.Shop::addSqlRestrictionOnLang('pl').')

						WHERE pl.`id_lang` = '.(int)$id_lang.'

						ORDER BY pl.`name`';

				$resAllProd = Db::getInstance()->ExecuteS($sqlSelProd);	$prodList = array(); foreach($resAllProd as $prod){ $prodList[$prod['id_product']] = $prod['name'];}

				$sql="SELECT * FROM "._DB_PREFIX_."omicrontabsettings WHERE id_shop = ".$id_shop." ORDER BY position";	

				$resSql = Db::getInstance()->ExecuteS($sql);

				

				$i=0;

						$divLangName='';

						foreach($resSql as $res){

							$divLangName .= 'aliasname_'.$res['id_tab'].'¤';

							$divLangName .= 'aliasname1_'.$res['id_tab'].'¤';

						}

						

				

				

				$html.='<div class="heading"><h3 class="title"><span class="icon16 icomoon-icon-cog"></span>'.$this->l('Select New Sections').'</h3></div>

				<h3 class="title"><span class="wpzoom-settings"></span>'.$this->l('Select New Sections').'</h3>

				<div class="admin-content">

				<table>

				<tr><td>

				<select id="rootCat" name="rootCat">

				<option value="Custom section_custom">'.$this->l('Custom section').'</option>

					'.$this->renderCategories($blockCategTree['children'],0).'

					<option value="Featured products_special">Featured Products</option>

					<option value="New Arrivals_special">New Arrivals</option>

					

					

				</select>

				</td>

				<td>

				<input type="hidden" id="selectedTab" name="selectedTab" value="" />

				<input type="submit" name="submit_add" id="submit_add" value="'.$this->l('Add Section').'" class="button btn btn-success" />

				</td></tr></table>

				</div>

				<div class="mainDiv">	

				<div class="language_colum">

				<div class="heading">

				<h3 class="title"><span class="wpzoom-settings"></span>'.$this->l('Created Sections').''; 

				$html.='</h3></div></div>';

				

				

				$html.='<div class="sections_column">

						<div class="create_section"	>	

					

						

						<ul id="sortable" class="tabs">';



				foreach($resSql as $res){

					$html.='<li id="'.$res['id_tab'].'" class="section_tab" rel="div_'.$res['id_tab'].'">';

					foreach ($languages as $language){

										   $sqlName="SELECT alias_name FROM "._DB_PREFIX_."omicrontabsettingslang WHERE id_lang = ".(int)$language['id_lang']." AND tab_id=".$res['id_tab'];	

											$aliasName = Db::getInstance()->getValue($sqlName);

											

						$html.='<div id="aliasname1_'.$res['id_tab'].'_'.(int)$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang ? 'block' : 'none').';float: left;">

						<a href="#div_'.$res['id_tab'].'" class="tab_head">'.$aliasName.'</a><span class="cross" id="del_'.$res['id_tab'].'">delete</span></div>';

						

					}

					

					$html.='</li>';

				}

				

				$html.='</ul>

					

					</div>

					<div class="tab_container">';

						foreach($resSql as $res){

							$html.='<div id="div_'.$res['id_tab'].'"';	if($i) $html.='style="display:none;"';	$html.=' class="tab_content">

									<table width="100%">

										<tr>

											<td width="45%">'.$this->l('Section Title').'</td>

											<td width="5%">:</td>

											<td width="50%"><div class="lable_lang">';

										

										foreach ($languages as $language){

										   $sqlName="SELECT alias_name FROM "._DB_PREFIX_."omicrontabsettingslang WHERE id_lang = ".(int)$language['id_lang']." AND tab_id=".$res['id_tab'];	

											$aliasName = Db::getInstance()->getValue($sqlName);

											

											$html.='<div id="aliasname_'.$res['id_tab'].'_'.(int)$language['id_lang'].'" style="display: '.($language['id_lang'] == $id_lang ? 'block' : 'none').';float: left;">

												<input type="text" name="aliasname_'.$res['id_tab'].'_'.(int)$language["id_lang"].'" id="aliasname_'.$res['id_tab'].'_'.(int)$language["id_lang"].'"  value="'.$aliasName.'" style="width:200px"/></div>'; 

										}

										$html.=''.$this->displayFlags($languages, (int)$id_lang, $divLangName, 'aliasname_'.$res['id_tab'], true);

										

							$html.='</div></td>

										</tr>

										<tr style="display:none;">

											<td>Position</td>

											<td>:</td>

											<td>

											<select  name="position_'.$res['id_tab'].'" id="position_'.$res['id_tab'].'">';

											for($pos=1; $pos<=count($resSql);$pos++){

												$html.=	'<option value="'.$pos.'"';

												if($res['position'] == $pos){ $html.='selected="selected"';}

											$html.=	'>'.$pos.'</option>';

											}

										$html.=	'</select>

											</td>

										</tr>

										<tr>

											<td>'.$this->l('Status').'</td>

											<td>:</td>

											<td><input type="radio" name="status_'.$res['id_tab'].'" id="status_1_'.$res['id_tab'].'"  value="1" ';

											if($res['status'] == 1){ $html.='checked="checked"'; }

											$html.='/> '.$this->l('on').'

										    <input type="radio" name="status_'.$res['id_tab'].'" id="status_0_'.$res['id_tab'].'"  value="0"';											

											if($res['status'] == 0){$html.='checked="checked"';}											

											$html.='/>'.$this->l('off').'</td>

										</tr>';

										

										

										if($res['type'] == "custom"){

											$html.='

											<tr>

												<td colspan="3" style="padding-bottom:0px; font-family:arial; font-weight:bold;">Add Products</td>

											</tr>

											<tr>

												<td colspan="3">

													<table>

														<tr>

															<td>

													<select name="prodList_'.$res['id_tab'].'" id="prodList_'.$res['id_tab'].'" multiple="multiple" style="width:180px; height:160px;">';

														foreach($resAllProd as $prod){

															$html.='<option value="'.$prod['id_product'].'">'.$prod['name'].'</option>';

														}

											$html.='

													</select>

													

												</td>

												<td>

													<div class="dualBtn">

														<input type="button" name="addProd_'.$res['id_tab'].'" id="addProd_'.$res['id_tab'].'" class="addProd btn btn-success"  value="Add >>"/>

														<input type="button" name="remProd_'.$res['id_tab'].'" id="remProd_'.$res['id_tab'].'" class="remProd btn btn-danger"  value="<< Remove"/>

														

													</div>

												</td>

												<td>

													

													<select name="selProdList_'.$res['id_tab'].'" id="selProdList_'.$res['id_tab'].'" class="selProdList" multiple="multiple" style="width:180px; height:160px;">';

													//$prodList

													$sqlSelTab = "SELECT products FROM "._DB_PREFIX_."omicrontab_products WHERE tab_id=".$res['id_tab'];

													$resProd=  Db::getInstance()->getValue($sqlSelTab);

													if($resProd){	

														$resProdArr = explode(",",$resProd);													

														foreach($resProdArr as $prodId){

															$html.='<option value="'.$prodId.'">'.$prodList[$prodId].'</option>';

														}

													}

											$html.='		

													</select>

													

												</td>

														</tr>

													</table>

												</td>

											</tr>';

										}

										$html.='

										<tr>

										

										

											<td colspan="3">

												<input type="submit" name="submit_'.$res['id_tab'].'" id="submit_'.$res['id_tab'].'" value="'.$this->l('Save Settings').'" class="submitTab btn btn-success" />

											</td>

										

										</tr>

									</table>							

									

							</div>

							';$i++;

						}		

						

				$html.='

				</div>		

					</div>

				</div>

				<input type="hidden" name="tabid" id="tabid"  value=""/>

				<input type="hidden" name="selProduct" id="selProduct"  value=""/>

				<input type="hidden" name="path_1" id="path_1" value="'._MODULE_DIR_.$this->name.'/" />

				<script>

					$(document).ready(function(){

						$("#submit_add").click(function(){ $("#selectedTab").val($("#rootCat").val());	});

						

						$(".tab_content").hide();

						$(".tab_content:first").hide(); 

					

						$("ul.tabs li").click(function() {

							$("ul.tabs li").removeClass("active");

							$(this).addClass("active");

							$(".tab_content").hide();

							var activeTab = $(this).attr("rel"); 

							$("#"+activeTab).fadeIn("slow"); 

						});

						

						

						$(".submitTab").click(function(){

							var subArr = $(this).attr("id").split("_"); $("#tabid").val(subArr[1]);								

						});

						

						$(".addProd").click(function(){

							var tabIdArr = $(this).attr("id").split("_"); var tabId = tabIdArr[1];

							var orgProd = "prodList_"+tabId; var selProd = "selProdList_"+tabId;

							var flag=0; var valSel ="";

							$("#"+orgProd+" option:selected").each(function(){

								flag=1; valSel = $(this).val();

								$("#"+selProd+" option").each(function(){ if(valSel == $(this).val()){ flag=0; } });

								if(flag){ var option =$(this).clone(); $("#"+selProd).append(option); }

							});

							$("#selProdList_"+tabId+" option").prop("selected", "selected");

							$("#selProduct").val($("#selProdList_"+tabId).val());

							$("#selProdList_"+tabId+" option").prop("selected", "");

							$("#"+orgProd+" option:selected").prop("selected", "");

						});

						

						$(".remProd").click(function(){	

							var tabIdArr = $(this).attr("id").split("_");

							var selProd = "selProdList_"+tabIdArr[1];

							$("#"+selProd+" option:selected").remove();

							$("#selProdList_"+tabIdArr[1]+" option").prop("selected", "selected");

							$("#selProduct").val($("#selProdList_"+tabIdArr[1]).val());

							$("#selProdList_"+tabIdArr[1]+" option").prop("selected", "");

						});

						

						

						$(".cross").click(function(){

							var flag = confirm("Are you sure to delete this section?");

							

							if(flag == true){

								var idArr = $(this).attr("id").split("_");	 var path = $("#path_1").val()+"ajaxPage.php?callFor=delete&id_tab="+idArr[1];

								

								$.ajax({

									url:path,

									success:function(data){	

									$("#"+idArr[1]).remove();

									$("#div_"+idArr[1]).remove();

										$(".confirm").hide("slow");

										$(".deleted").show("slow").delay(3000).fadeOut("slow");

										

									} });

							}else{ return false; }

							

							

						});

					});

				</script>

			</fieldset>

		</div>

		</form>';

		return $html;

	}

	

	public function hookdisplayHome($params)

	{

		global $smarty,$cookie;

		$id_shop = $this->context->shop->id;

		$this->context->controller->addCSS(($this->_path).'styles/omicronCategories.css', 'all');

		$this->context->controller->addJS(($this->_path).'javascript/omicronCategories.js');

		$id_lang = (int)Context::getContext()->language->id;

		$selCat = Configuration::get('DISPLAY_omicron_CATEGORY');

		$selCatArr = explode("##",$selCat);

		$catProds = array();

		$allProds = array();

		

		$prodImages = array();

		$allProdArr = array();

		$allProd = array();

		

		$prodCategory = "";

		

		$category = new Category(Context::getContext()->shop->getCategory(), (int)Context::getContext()->language->id);	

	

		$new_products = Product::getNewProducts((int)($params['cookie']->id_lang), 0, 10);

		$featured_products = $category->getProducts((int)($params['cookie']->id_lang), 0, 100);



		

		$sqlSel = "SELECT * FROM "._DB_PREFIX_."omicrontabsettings WHERE status='1' AND id_shop = ".$id_shop." ORDER BY position ASC";

		$resultant = Db::getInstance()->ExecuteS($sqlSel);

		$flagExists = 0;

		foreach($resultant as $result){ $flagExists = 1;

			$sqlName = "SELECT alias_name FROM "._DB_PREFIX_."omicrontabsettingslang WHERE tab_id=".$result['id_tab']." AND id_lang = ".$id_lang;

			$aliasName = Db::getInstance()->getValue($sqlName);

			extract($result);

			

			if($type == "category"){							

				$categoryObj = new Category($cat_id);

				$catProds =$categoryObj->getProducts((int)($params['cookie']->id_lang), 0, 100); 				

				if($catProds){

					$catDisplay[$id_tab] = str_replace(' ','_',($aliasName)); $catDisplayName[$id_tab] = ($aliasName);

					$catDisplayName[$id_tab] = ($aliasName);

					foreach($catProds as $prod1){

							$allProds[$prod1['id_product']] = $prod1;

							//Thumb image coding started ($prod changed to $prod1 on previous line and last line)

							$prod = new Product($prod1['id_product']);

						$images = $prod->getImages((int)$this->context->cookie->id_lang);

						$product_images = array();

						foreach ($images as $k => $image)

						{

							$product_images[(int)$image['id_image']] = $image;

						}

						$prodImages[$prod1['id_product']] = $product_images;

						$allProdArr[$prod1['id_product']] = $prod1;

							//Thumb image coding ended



							$prodCategory .= str_replace(' ','_',($aliasName))."::".$prod1['id_product']."##";					

					}

				}

			}elseif($type == "special"){

				if($name == 'New Arrivals'){

					if($new_products){

						$catDisplay[$id_tab] =  str_replace(' ','_',($aliasName)); $catDisplayName[$id_tab] = ($aliasName);

						foreach($new_products as $prod1){

							$allProds[$prod1['id_product']] = $prod1;

							//Thumb image coding started ($prod changed to $prod1 on previous line and last line)

							$prod = new Product($prod1['id_product']);

						$images = $prod->getImages((int)$this->context->cookie->id_lang);

						$product_images = array();

						foreach ($images as $k => $image)

						{

							$product_images[(int)$image['id_image']] = $image;

						}

						$prodImages[$prod1['id_product']] = $product_images;

						$allProdArr[$prod1['id_product']] = $prod1;

									//Thumb image coding ended

							$prodCategory .= str_replace(' ','_',($aliasName))."::".$prod1['id_product']."##";

						}

					}

				}

				else if($name == 'Featured products'){

					if($featured_products){

						$catDisplay[$id_tab] =  str_replace(' ','_',($aliasName)); $catDisplayName[$id_tab] = ($aliasName);

						foreach($featured_products as $prod1){							

							$allProds[$prod1['id_product']] = $prod1;

							//Thumb image coding started ($prod changed to $prod1 on previous line and last line)

							$prod = new Product($prod1['id_product']);

						$images = $prod->getImages((int)$this->context->cookie->id_lang);

						$product_images = array();

						foreach ($images as $k => $image)

						{

							$product_images[(int)$image['id_image']] = $image;

						}

						$prodImages[$prod1['id_product']] = $product_images;

						$allProdArr[$prod1['id_product']] = $prod1;

						//Thumb image coding ended

							$prodCategory .= str_replace(' ','_',($aliasName))."::".$prod1['id_product']."##";

						}

					}

				}

			}elseif($type == "custom"){		

				

				$sqlSelProd = "SELECT products FROM "._DB_PREFIX_."omicrontab_products WHERE tab_id=".$id_tab;

				$resultProd = Db::getInstance()->getValue($sqlSelProd);

				

				

				if($resultProd){	

				$catDisplay[$id_tab] =  str_replace('',"",('section_0_'.$id_tab)); $catDisplayName[$id_tab] = ($aliasName);

					$prodArr = explode(",", $resultProd);					

						foreach($prodArr as $prodIdI){

							

						$res = $this->getProductById($prodIdI['id_product']);

						$prod = new Product($prodIdI);

						$catProds =$category->getProducts((int)($params['cookie']->id_lang), 0, 100);

						

						foreach($catProds as $catProd){

							if($catProd['id_product'] == $prod->id){

								$allProds[$prodIdI] = $catProd;

							}

						

						$images = $prod->getImages((int)$this->context->cookie->id_lang);

						$product_images = array();

						foreach ($images as $k => $image)

						{

							$product_images[(int)$image['id_image']] = $image;

						}

						$prodImages[$prodIdI] = $product_images;

						$allProdArr[$prodIdI['id_product']] = $prodIdI;

						

						}

												

						$prodCategory .= str_replace('',"",('section_0_'.$id_tab))."::".$prodIdI."##";

						

					}

					

				}

				

			}

		}

		

		$this->smarty->assign(array(

			'products' => $allProds,

			'allProd' => $allProd,

			'prodImages' => $prodImages,

			'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),			

			'homeSize' => Image::getSize('home_default'),			

			'prodCategory' => $prodCategory

		));

		

		$smarty->assign('selCatArr',@$catDisplay); 

		$smarty->assign('selCatNameArr',@$catDisplayName); 

		$smarty->assign('flagExists',$flagExists); 

		

	}

	public function hookhometabCategory($params)

	{

		return $this->display(__FILE__, 'omicronCategories.tpl');

		

		}



	function objectArrayToArray($obj){

		;

	}

	public function renderCategories($categories,$level)

	{	$output='';		

		foreach($categories as $category)

		{

			/*for($i=0;$i<$level;$i++){

				$output.='&nbsp&nbsp&nbsp&nbsp';

			}*/

			//$output.= "<input type='checkbox' class='category' id='category_".$category['id']."' name='category_".$category['id']."' value='".$category['id']."'>&nbsp;".$category['name'];

			$output.= "<option value='".$category['name']."_category_".$category['id']."'>".$category['name']."</option>";

			if(count($category['children']) > 0)

			{

				$output.= $this->renderCategories($category['children'],$level+1);

			}

		}

		return $output;

	}

	

	function getProductById($productId){

		global $cookie, $context;$id_category='';

		$id_lang = (int)($cookie->id_lang);

		$sql = 'SELECT p.*, product_shop.*, stock.out_of_stock, IFNULL(stock.quantity, 0) as quantity, MAX(product_attribute_shop.id_product_attribute) id_product_attribute, product_attribute_shop.minimal_quantity AS product_attribute_minimal_quantity, pl.`description`, pl.`description_short`, pl.`available_now`,

					pl.`available_later`, pl.`link_rewrite`, pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`, pl.`name`, MAX(image_shop.`id_image`) id_image,

					il.`legend`, m.`name` AS manufacturer_name, cl.`name` AS category_default,

					DATEDIFF(product_shop.`date_add`, DATE_SUB(NOW(),

					INTERVAL '.(Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20).'

						DAY)) > 0 AS new, product_shop.price AS orderprice

				FROM `'._DB_PREFIX_.'category_product` cp

				LEFT JOIN `'._DB_PREFIX_.'product` p

					ON p.`id_product` = cp.`id_product`

				'.Shop::addSqlAssociation('product', 'p').'

				LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa

				ON (p.`id_product` = pa.`id_product`)

				'.Shop::addSqlAssociation('product_attribute', 'pa', false, 'product_attribute_shop.`default_on` = 1').'

				'.Product::sqlStock('p', 'product_attribute_shop', false, $context->shop).'

				LEFT JOIN `'._DB_PREFIX_.'category_lang` cl

					ON (product_shop.`id_category_default` = cl.`id_category`

					AND cl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('cl').')

				LEFT JOIN `'._DB_PREFIX_.'product_lang` pl

					ON (p.`id_product` = pl.`id_product`

					AND pl.`id_lang` = '.(int)$id_lang.Shop::addSqlRestrictionOnLang('pl').')

				LEFT JOIN `'._DB_PREFIX_.'image` i

					ON (i.`id_product` = p.`id_product`)'.



				Shop::addSqlAssociation('image', 'i', false, 'image_shop.cover=1').'

				LEFT JOIN `'._DB_PREFIX_.'image_lang` il

					ON (image_shop.`id_image` = il.`id_image`

					AND il.`id_lang` = '.(int)$id_lang.')

				LEFT JOIN `'._DB_PREFIX_.'manufacturer` m

					ON m.`id_manufacturer` = p.`id_manufacturer`

				WHERE product_shop.`id_shop` = '.(int)$context->shop->id.'

					AND p.`id_product` = '.(int)$productId.' GROUP BY product_shop.id_product';

					

		$rq = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);		



		return Product::getProductsProperties($id_lang, $rq);

	}

}